<?php
session_start();
include("../db.php");

$total = $conn->query("SELECT COUNT(*) as t FROM members")->fetch_assoc()['t'];

$male = $conn->query("SELECT COUNT(*) as t FROM members WHERE gender='Male'")->fetch_assoc()['t'];

$female = $conn->query("SELECT COUNT(*) as t FROM members WHERE gender='Female'")->fetch_assoc()['t'];

$children = $conn->query("SELECT COUNT(*) as t FROM members WHERE TIMESTAMPDIFF(YEAR,dob,CURDATE()) < 18")->fetch_assoc()['t'];

$devices_given = $conn->query("SELECT COUNT(*) as t FROM assistive_devices WHERE status='Given'")->fetch_assoc()['t'];

$devices_requested = $conn->query("SELECT COUNT(*) as t FROM assistive_devices WHERE status='Requested'")->fetch_assoc()['t'];

$applications = $conn->query("SELECT COUNT(*) as t FROM member_applications WHERE status='Pending'")->fetch_assoc()['t'];

$branches = $conn->query("SELECT branch, COUNT(*) as total FROM members GROUP BY branch");

$branch_names = [];
$branch_totals = [];

while($b = $branches->fetch_assoc()){
$branch_names[] = $b['branch'];
$branch_totals[] = $b['total'];
}
?>

<!DOCTYPE html>
<html>
<head>

<title>ZANAB Dashboard</title>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>

body{
font-family:Arial;
margin:0;
background:#f4f6fb;
}

.sidebar{
width:220px;
height:100vh;
background:#0b3d91;
position:fixed;
color:white;
padding-top:20px;
}

.sidebar h2{
text-align:center;
}

.sidebar a{
display:block;
padding:12px;
color:white;
text-decoration:none;
}

.sidebar a:hover{
background:#082c6c;
}

.main{
margin-left:220px;
padding:30px;
}

.cards{
display:flex;
flex-wrap:wrap;
}

.card{
background:white;
padding:20px;
margin:10px;
width:200px;
border-radius:10px;
box-shadow:0 2px 8px rgba(0,0,0,0.2);
text-align:center;
}

.chart-box{
background:white;
padding:20px;
margin-top:20px;
border-radius:10px;
box-shadow:0 2px 8px rgba(0,0,0,0.2);
}

</style>

</head>

<body>

<div class="sidebar">

<h2>ZANAB</h2>

<a href="dashboard.php">Dashboard</a>
<a href="members.php">Members</a>
<a href="add_member.php">Add Member</a>
<a href="applications.php">Applications (<?php echo $applications; ?>)</a>
<a href="statistics.php">Statistics</a>
<a href="add_device.php">Assistive Devices</a>
<a href="projects.php">Projects</a>
<a href="programs.php">Programs</a>
<a href="news.php">News</a>
<a href="gallery.php">Gallery</a>
<a href="partners.php">Partners</a>
<a href="edit_about.php">About Website</a>
<a href="staff.php">Staff Management</a>
<a href="logout.php">Logout</a>

</div>

<div class="main">

<h1>ZANAB Dashboard</h1>

<div class="cards">

<div class="card">
<h3>Total Members</h3>
<h2><?php echo $total; ?></h2>
</div>

<div class="card">
<h3>Male Members</h3>
<h2><?php echo $male; ?></h2>
</div>

<div class="card">
<h3>Female Members</h3>
<h2><?php echo $female; ?></h2>
</div>

<div class="card">
<h3>Children</h3>
<h2><?php echo $children; ?></h2>
</div>

<div class="card">
<h3>Devices Given</h3>
<h2><?php echo $devices_given; ?></h2>
</div>

<div class="card">
<h3>Devices Requested</h3>
<h2><?php echo $devices_requested; ?></h2>
</div>

<div class="card">
<h3>Pending Applications</h3>
<h2><?php echo $applications; ?></h2>
</div>

</div>

<div class="chart-box">
<h3>Members by Gender</h3>
<canvas id="genderChart"></canvas>
</div>

<div class="chart-box">
<h3>Members by Branch</h3>
<canvas id="branchChart"></canvas>
</div>

</div>

<script>

const genderChart = new Chart(
document.getElementById('genderChart'),
{
type:'pie',
data:{
labels:['Male','Female'],
datasets:[{
data:[<?php echo $male ?>,<?php echo $female ?>],
backgroundColor:['#3498db','#e74c3c']
}]
}
}
);

const branchChart = new Chart(
document.getElementById('branchChart'),
{
type:'bar',
data:{
labels:<?php echo json_encode($branch_names) ?>,
datasets:[{
label:'Members',
data:<?php echo json_encode($branch_totals) ?>,
backgroundColor:'#3498db'
}]
}
}
);

</script>

</body>
</html>