<?php require_once("db.php"); ?>
<!DOCTYPE html>
<html>
<head>
<title>ZANAB | Home</title>
<meta charset="UTF-8">
<link rel="stylesheet" href="css/style.css">

<style>
body{
font-family:Arial, sans-serif;
margin:0;
background:#f4f6fb;
}

header{
background:#0b3d91;
color:white;
padding:15px;
display:flex;
align-items:center;
}

header img{
height:70px;
margin-right:15px;
}

nav{
background:#082c6c;
padding:12px;
text-align:center;
}

nav a{
color:white;
margin:0 15px;
text-decoration:none;
font-weight:bold;
}

.section{
padding:50px 20px;
text-align:center;
}

.card{
background:white;
padding:20px;
margin:15px;
border-radius:10px;
box-shadow:0 2px 8px rgba(0,0,0,0.15);
display:inline-block;
width:300px;
vertical-align:top;
}

footer{
background:#0b3d91;
color:white;
text-align:center;
padding:20px;
margin-top:40px;
}
</style>
</head>

<body>

<header>
<img src="uploads/logo.png">
<div>
<h2 style="margin:0;">ZANAB</h2>
<small>Zanzibar National Association of the Blind</small>
</div>
</header>

<nav>
<a href="index.php">Home</a>
<a href="programs.php">Programs</a>
<a href="projects.php">Projects</a>
<a href="news.php">News</a>
<a href="donate.php">Donate</a>
<a href="contact.php">Contact</a>
<a href="staff/login.php">Staff Login</a>
</nav>

<!-- SLIDESHOW -->
<div class="slideshow-container">
<img src="uploads/slide1.jpg" style="width:100%">
</div>

<!-- ABOUT -->
<div class="section">
<h2>About ZANAB</h2>
<p>
ZANAB is a Non-Governmental Organization owned by People with Blindness in Zanzibar.
We promote inclusion, equal rights, empowerment and development.
</p>
</div>

<!-- PROGRAMS -->
<div class="section">
<h2>Our Programs</h2>

<div class="card">
<h3>Economic Empowerment</h3>
<p>Income generating activities and entrepreneurship support.</p>
</div>

<div class="card">
<h3>Inclusive Education</h3>
<p>Promotion of inclusive education and Braille learning.</p>
</div>

<div class="card">
<h3>Health & Rehabilitation</h3>
<p>Community based rehabilitation services.</p>
</div>

</div>

<!-- PROJECTS -->
<div class="section">
<h2>Our Projects</h2>

<?php
$r = $conn->query("SELECT * FROM projects ORDER BY id DESC LIMIT 3");

if($r && $r->num_rows > 0){
while($row = $r->fetch_assoc()){
?>

<div class="card">
<h3><?php echo htmlspecialchars($row['title']); ?></h3>
<p><?php echo substr(htmlspecialchars($row['description']),0,120); ?>...</p>
<p><b>Status:</b> <?php echo htmlspecialchars($row['status']); ?></p>
</div>

<?php
}
}else{
echo "<p>No projects available yet.</p>";
}
?>

<br><br>

<a href="projects.php" style="background:#0b3d91;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;">
View All Projects
</a>

</div>

<footer>
© <?php echo date("Y"); ?> ZANAB | All Rights Reserved
</footer>

</body>
</html>